/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1986,1987,1988,1989,1990 Texas Instruments Incorporated.*/
/*  All rights reserved.                                                 */
/*                                                                       */

#include <:bsd:sys:grp.h>
#include <stdio.h>

struct group *getgrent();

/********************************************************/
/* GETGROUPS gets the current group access list of the  */
/* user process and stores it in the array GRP_NO_ARRAY */
/* The parameter NO_OF_GROUPS indicates the number of   */
/* entries which may be placed in GRP_NO_ARRAY.         */
/* GETGROUPS returns the actual no of entries placed    */
/* in the GRP_NO_ARRAY                                  */
/********************************************************/
getgroups(no_of_groups, grp_no_array)
int  no_of_groups;
int  grp_no_array[];
{ 
	int            i;
	struct group   *grp_ptr;

	/* call 'getgrent' routine to get the numerical group ID 
	and store it in grp_no_array */
	i = 0;
	while ((grp_ptr = getgrent()) != (struct group *)NULL &&
 		i < no_of_groups ) 
	grp_no_array[i++] = grp_ptr->gr_gid;

	if (i >= no_of_groups)
		return(i - 1);
	return(i) ;

}
